<main id="main" class="main">

  <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-header mb-4">
            <div class="row align-items-center">
              <div class="col-sm-6">
                <h4 class="text-dark mb-0"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6 text-end">
                <button class="btn btn-success rounded add-btn" type="button" onclick="add()">
                  <i class="bi bi-plus"></i> Add <?= $title; ?>
                </button>
              </div>
            </div>
          </div>

          <div class="card-body">
            <!-- Table -->
            <div class="table-responsive" id="tb"></div>
            <!-- End Table -->
          </div>
        </div>

      </div>
    </div>
  </section>

</main><!-- End #main -->

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="add-form">

          <!-- Property Selection -->
          <div class="col-md-6">
            <label for="property_id" class="form-label fw-semibold">Select Property</label>
            <select class="form-control" id="property_id" name="property_id" required>
              <option value="">Select Property</option>
              <?php foreach ($properties as $property): ?>
                <option value="<?= $property['id']; ?>"><?= $property['name']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <!-- Room Selection -->
          <div class="col-md-6">
            <label for="room_id" class="form-label fw-semibold">Select Room</label>
            <select class="form-control" id="room_id" name="room_id" required>
              <option value="">Select Room</option>
            </select>
          </div>

          <hr class="my-3">

          <!-- Dynamic Date-Price Rows -->
          <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-2">
              <h6 class="mb-0 fw-semibold">Set Prices for Date Ranges</h6>
              <button type="button" class="btn btn-sm btn-outline-success" id="addRowBtn">
                <i class="bi bi-plus-circle"></i> Add More
              </button>
            </div>

            <div class="table-responsive">
              <table class="table table-bordered align-middle" id="priceTable">
                <thead class="table-light">
                  <tr>
                    <th style="width:60%">Date Range</th>
                    <th style="width:30%">Price</th>
                    <th style="width:10%">Action</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>
                      <select class="form-control" name="price_date_id[]" required>
                        <option value="">Select Date Range</option>
                        <?php foreach ($price_dates as $pd): ?>
                          <option value="<?= $pd['id']; ?>">
                            <?= $pd['name']; ?> (<?= date('d M', strtotime($pd['from_date'])) . ' - ' . date('d M Y', strtotime($pd['to_date'])); ?>)
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </td>
                    <td>
                      <input type="number" class="form-control" name="price[]" placeholder="Enter price" required>
                    </td>
                    <td class="text-center">
                      <button type="button" class="btn btn-sm btn-outline-danger removeRowBtn"><i class="bi bi-trash"></i></button>
                    </td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>

          <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>


      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Edit <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
          <form class="row g-3" id="edit-form">

            <!-- Property Selection -->
            <div class="col-md-6">
              <label for="e_property_id" class="form-label fw-semibold">Select Property</label>
              <select class="form-control" id="e_property_id" name="property_id" required>
                <option value="">Select Property</option>
                <?php foreach ($properties as $property): ?>
                  <option value="<?= $property['id']; ?>"><?= $property['name']; ?></option>
                <?php endforeach; ?>
              </select>
            </div>

            <!-- Room Selection -->
            <div class="col-md-6">
              <label for="e_room_id" class="form-label fw-semibold">Select Room</label>
              <select class="form-control" id="e_room_id" name="room_id" required>
                <option value="">Select Room</option>
              </select>
            </div>

            <hr class="my-3">

            <!-- Dynamic Date-Price Table -->
            <div class="col-12">
              <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0 fw-semibold">Set Prices for Date Ranges</h6>
                <button type="button" class="btn btn-sm btn-outline-success" id="addPriceRow">
                  <i class="bi bi-plus-circle"></i> Add More
                </button>
              </div>

              <div class="table-responsive">
                <table class="table table-bordered align-middle" id="editPriceTable">
                  <thead class="table-light">
                    <tr>
                      <th style="width:60%">Date Range</th>
                      <th style="width:30%">Price</th>
                      <th style="width:10%">Action</th>
                    </tr>
                  </thead>
                  <tbody id="priceRows">
                    <!-- JS will append rows here -->
                  </tbody>
                </table>
              </div>
            </div>

            <div class="col-12 text-end mt-3">
              <input type="hidden" id="e_id" name="id">
              <button type="submit" class="btn btn-primary">Save</button>
              <button type="reset" class="btn btn-outline-danger">Reset</button>
            </div>

          </form>





      </div>
    </div>
  </div>
</div>

<script>
function add() {
  $('#addModal').modal('show'); 
  $('#add-form')[0].reset();
  $('#room_id').html('<option value="">Select Room</option>');
}

$(document).ready(function(){  
  $("#tb").html('<div class="text-center"><img src="loader.gif" style="width:50px;"></div>');
  $('#tb').load('<?= base_url('room_pricing/viewPricing'); ?>');
});

// Populate Rooms on Property Change (Add Modal)
$('#property_id').on('change', function(){
  var propertyId = $(this).val();
  if(propertyId){
    $.post("<?= base_url('room_pricing/getRoomsByProperty'); ?>",{property_id:propertyId}, function(res){
      $('#room_id').html(res);
    });
  }else{
    $('#room_id').html('<option value="">Select Room</option>');
  }
});

// Populate Rooms on Property Change (Edit Modal)
$('#e_property_id').on('change', function(){
  var propertyId = $(this).val();
  if(propertyId){
    $.post("<?= base_url('room_pricing/getRoomsByProperty'); ?>",{property_id:propertyId}, function(res){
      $('#e_room_id').html(res);
    });
  }else{
    $('#e_room_id').html('<option value="">Select Room</option>');
  }
});

// Add Pricing
$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('room_pricing/addPricing'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType:'json',
    success:function(res){
      enableButton();
      if(res.return){
        $('#addModal').modal('hide'); 
        $('#add-form')[0].reset();
        $('#tb').load('<?= base_url('room_pricing/viewPricing'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});


function editData(id) {
    $.ajax({
        url: "<?= base_url('room_pricing/editPricing'); ?>",
        method: "POST",
        dataType: 'json',
        data: { id: id },
        success: function(res) {
            // Set property
            $("#e_property_id").val(res.property_id).trigger('change');

            // Delay to populate rooms
            setTimeout(function(){
                $("#e_room_id").val(res.room_id);
            }, 500);

            // Clear existing price rows
            $("#priceRows").html('');

            // Populate existing prices
            if(res.prices.length > 0){
                res.prices.forEach(function(p){
                    addPriceRow(p.price_date_id, p.price, p.pricing_id);
                });
            } else {
                addPriceRow(); // Add at least 1 empty row
            }

            $('#editModal').modal('show');
        }
    });
}

// Add a price row (prefilled if values provided)
function addPriceRow(price_date_id = '', price = '', pricing_id = ''){
    var options = `<?php foreach ($price_dates as $pd): ?>
        <option value="<?= $pd['id']; ?>"><?= $pd['name']; ?> (<?= date('d M', strtotime($pd['from_date'])) ?> - <?= date('d M Y', strtotime($pd['to_date'])) ?>)</option>
    <?php endforeach; ?>`;

    var row = `
    <tr class="price-row">
        <input type="hidden" name="pricing_id[]" value="${pricing_id}">
        <td>
            <select class="form-control" name="price_date_id[]" required>
                <option value="">Select Date Range</option>
                ${options}
            </select>
        </td>
        <td>
            <input type="number" class="form-control" name="price[]" placeholder="Enter Price" value="${price}" required>
        </td>
        <td class="text-center">
            <button type="button" class="btn btn-sm btn-outline-danger removeRow"><i class="bi bi-trash"></i></button>
        </td>
    </tr>`;

    $("#priceRows").append(row);

    // Set selected date
    if(price_date_id){
        $("#priceRows tr:last select[name='price_date_id[]']").val(price_date_id);
    }
}

// Add new empty row
$("#addPriceRow").click(function(){ addPriceRow(); });

// Remove row
$(document).on('click', '.removeRow', function(){
    $(this).closest('tr.price-row').remove();
});





// Update Pricing
$("#edit-form").submit(function(e){
    e.preventDefault();
    disableButton();
    $.ajax({
        url: "<?= base_url('room_pricing/updatePricing'); ?>",
        method: "POST",
        data: new FormData(this),
        cache: false,
        contentType: false,
        processData: false,
        dataType:'json',
        success:function(res){
            enableButton();
            if(res.return){
                $('#editModal').modal('hide'); 
                $('#edit-form')[0].reset();
                $('#tb').load('<?= base_url('room_pricing/viewPricing'); ?>');
                toastr.success(res.msg);
            } else {
                toastr.error(res.msg);
            }
        }
    });
});

</script>



<script>
$(document).ready(function() {

  // load rooms by property
  $('#property_id').change(function() {
    var property_id = $(this).val();
    if (property_id) {
      $.ajax({
        url: "<?= base_url('room_pricing/getRoomsByProperty'); ?>",
        method: "POST",
        data: { property_id: property_id },
        success: function(data) {
          $('#room_id').html(data);
        }
      });
    } else {
      $('#room_id').html('<option value="">Select Room</option>');
    }
  });

  // add new price-date row
  $('#addRowBtn').click(function() {
    const newRow = `
      <tr>
        <td>
          <select class="form-control" name="price_date_id[]" required>
            <option value="">Select Date Range</option>
            <?php foreach ($price_dates as $pd): ?>
              <option value="<?= $pd['id']; ?>">
                <?= $pd['name']; ?> (<?= date('d M', strtotime($pd['from_date'])) . ' - ' . date('d M Y', strtotime($pd['to_date'])); ?>)
              </option>
            <?php endforeach; ?>
          </select>
        </td>
        <td><input type="number" class="form-control" name="price[]" placeholder="Enter price" required></td>
        <td class="text-center">
          <button type="button" class="btn btn-sm btn-outline-danger removeRowBtn"><i class="bi bi-trash"></i></button>
        </td>
      </tr>`;
    $('#priceTable tbody').append(newRow);
  });

  // remove row
  $(document).on('click', '.removeRowBtn', function() {
    $(this).closest('tr').remove();
  });

});
</script>